<?php
// Router PHP para subdomínio farmland-investment.mercadorural.com.br

// Obter a URI da requisição
$requested_file = $_SERVER['REQUEST_URI'];

// Remover query string se existir
$requested_file = explode('?', $requested_file)[0];

// Remover barra inicial se existir
$requested_file = ltrim($requested_file, '/');

// Se estiver vazio, servir index.html
if (empty($requested_file)) {
    header('Content-Type: text/html; charset=utf-8');
    header('Cache-Control: public, max-age=3600');
    readfile(__DIR__ . '/index.html');
    exit;
}

// Verificar se é um arquivo CSS
if (preg_match('/\.css$/', $requested_file)) {
    header('Content-Type: text/css; charset=utf-8');
    header('Cache-Control: public, max-age=31536000');
    $file_path = __DIR__ . '/' . $requested_file;
    if (file_exists($file_path)) {
        readfile($file_path);
        exit;
    }
}

// Verificar se é um arquivo JS
if (preg_match('/\.js$/', $requested_file)) {
    header('Content-Type: application/javascript; charset=utf-8');
    header('Cache-Control: public, max-age=31536000');
    $file_path = __DIR__ . '/' . $requested_file;
    if (file_exists($file_path)) {
        readfile($file_path);
        exit;
    }
}

// Verificar se é uma imagem
if (preg_match('/\.(png|jpg|jpeg|gif|ico|svg)$/', $requested_file)) {
    $ext = pathinfo($requested_file, PATHINFO_EXTENSION);
    $mime_types = [
        'png' => 'image/png',
        'jpg' => 'image/jpeg',
        'jpeg' => 'image/jpeg',
        'gif' => 'image/gif',
        'ico' => 'image/x-icon',
        'svg' => 'image/svg+xml'
    ];
    
    if (isset($mime_types[$ext])) {
        header('Content-Type: ' . $mime_types[$ext]);
        header('Cache-Control: public, max-age=31536000');
        $file_path = __DIR__ . '/' . $requested_file;
        if (file_exists($file_path)) {
            readfile($file_path);
            exit;
        }
    }
}

// Para tudo mais, servir o index.html (React Router)
header('Content-Type: text/html; charset=utf-8');
header('Cache-Control: public, max-age=3600');
readfile(__DIR__ . '/index.html');
?>
