# .htaccess para SUBDOMÍNIO com PHP Router
# Força tudo através do router.php para controlar MIME types

# Forçar modo de reescrita
RewriteEngine On

# Não aplicar regras a arquivos que existem (para evitar loops)
RewriteCond %{REQUEST_FILENAME} -f
RewriteRule ^ - [L]

# Forçar tudo através do router.php (exceto o próprio router.php)
RewriteCond %{REQUEST_URI} !^/router\.php$
RewriteRule ^(.*)$ /router.php [L]

# Configurações de cache para arquivos estáticos
<IfModule mod_expires.c>
  ExpiresActive On
  ExpiresByType text/css "access plus 1 year"
  ExpiresByType application/javascript "access plus 1 year"
  ExpiresByType image/png "access plus 1 year"
  ExpiresByType image/jpg "access plus 1 year"
  ExpiresByType image/jpeg "access plus 1 year"
  ExpiresByType image/gif "access plus 1 year"
  ExpiresByType image/ico "access plus 1 year"
  ExpiresByType image/svg+xml "access plus 1 year"
  ExpiresByType text/html "access plus 1 hour"
</IfModule>

# Compressão
<IfModule mod_deflate.c>
  AddOutputFilterByType DEFLATE text/plain
  AddOutputFilterByType DEFLATE text/html
  AddOutputFilterByType DEFLATE text/css
  AddOutputFilterByType DEFLATE application/javascript
  AddOutputFilterByType DEFLATE application/json
</IfModule>

# Forçar UTF-8
AddDefaultCharset UTF-8
AddCharset UTF-8 .html .css .js .xml .json .rss
